;;;-----------------------------------------------------------------------------;;;
;;;  
;;;  ---------------------------------------------------------------------------;;;
;;;  SlopedRoof                                                                 ;;;
;;;  ---------------------------------------------------------------------------;;;
;;;  function : Find the ridge lines of sloped roof                             ;;;
;;;  ---------------------------------------------------------------------------;;;
;;;  Return:                                                                    ;;;
;;;         2D -- SlopedRoof Lines / SlopedRoof Closed Polygons of  Each Side   ;;;
;;;         3D -- SlopedRoof Closed Polygons of Each face                       ;;;
;;;                          / A Union Surface                                  ;;;
;;;                          / Solids of Each face                              ;;;
;;;  ---------------------------------------------------------------------------;;;
;;;  Writen By GSLS(SS) June 2014                                               ;;;
;;;        (C)  EasyCity OptDesign Studio of Building Structures                ;;;
;;;  Email: chlh_jd@126.com        Tel:86-0592-5391029    Fax:86-0592-5391020   ;;;
;;;  ---------------------------------------------------------------------------;;;
;;;  Main thread reference :                                                    ;;;
;;;      JianGuo Li, Algorithm about generate slopedroof line from 2D polygon.  ;;;
;;;      [BC Dissertation]Hubei University in China . 2009.                   ;;;
;;;      Many Thanks to JianGuo Li !                                            ;;;
;;;  -------------------------------------------                                ;;;
;;;  JianGuo Li's article main abort references :
;;;      [5] D.T.Lee. Medial axis transformation of a planar shape [J],IEEE Trans PAM I , 1982, 4:363-369
;;;      [6] Chin F, Snoeyink J., Wang C.A. Finding the medial axis of a simple polygon in linear time
;;;           [J]. Discrete and Computational Geometry , 1999, 21:405-420
;;;      [8] Joseph O,Rourke. Computational Geometry In C [M].Second Edition. Cambridge University Press, 2004.179-181
;;;      ......
;;;  ---------------------------------------------------------------------------;;;
;;;  Version revit See command Routine .                                        ;;;
;;;  -------------------------------------------                                ;;;
;;;  Thanks Ribar.M from http://www.theswamp.org  for do many test              ;;;
;;;  -------------------------------------------                                ;;;
;;;  Discuss website : http://www.theswamp.org/index.php?topic=41837.0          ;;;
;;;  -------------------------------------------                                ;;;
;;;  Any Advice will be welcome , Thank you !                                   ;;;
;;;  ---------------------------------------------------------------------------;;;
(defun c:2droof-final-orig
              (/ unique         dxf            _vl-position
                 ang-equal      ray-inters     ray-int-line
                 L_INT_PL       bisector       bisector2
                 lbisector      format-i       inzone?
                 pipl?          ss-pts2area    round
                 sign           eqmember       
                 vl-remove-doubles             remove-nth
                 TCGroup        eqgroup        assoc2
                 midpt          _vl-sort
                 _closed2       _Pedal         suit-i
                 used-si        pnth           add-item
                 suit           _closed        _getclosed
                 _getneighbor   _getsinglenoclosed
                 _getclosedinfo _closeditself  _get_minz
                 _getnoclosedpair              _getnoclosdedpairinfo
                 foo            foo1           ;_defined functions
                 err            adoc           area
                 scf ;_local variables         
                 *error*        
                 _odisfuzz      _oangfuzz      _olderr ;_error handle
                 #gsls_systemvar#              _2pi
                 _pi2           *gsls_angfuzz* *gsls_disfuzz*
                 *gsls_debug* ;_global variables
              )

  (or (not (vl-catch-all-error-p (vl-catch-all-apply (function vlax-get-acad-object) nil))) (vl-load-com))

  (setq _2pi           6.283185307179586476925286766559
        _pi2           1.5707963267948966192313216916395
        *gsls_angfuzz* 1e-7
        *gsls_disfuzz* 1e-3
        *gsls_debug*
                       nil
  )

  ;;----------------------- error handle
  (defun _svos ()
    (vla-startundomark
      (vla-get-activedocument (vlax-get-acad-object))
    )
    (setq #gsls_vlale#
                       (mapcar (function getvar) #gsls_systemvar#)
          _olderr      *error*
          _odisfuzz    *gsls_disfuzz*
          _oangfuzz    *gsls_angfuzz*
    )
    (defun *error* (msg)
      (_clos)
      (if msg (prompt msg))
      (princ)
    )
  )
  ;;-----------------------
  (defun _clos ()
    (if #gsls_vlale#
      (progn (MapCar (function (lambda (x y)
                                 (if y
                                   (setvar x y)
                                 )
                               )
                     )
                     #gsls_systemvar#
                     #gsls_vlale#
             )
             (setq #gsls_vlale# nil)
      )
    )
    (vla-EndUndoMark
      (vla-get-ActiveDocument (vlax-get-acad-object))
    )
    (setq *error* gsls_olderr
          *gsls_disfuzz*
           _odisfuzz
          *gsls_angfuzz*
           _oangfuzz
    )
    (princ)
  )
  ;;-----------------------
  ;|(defun list-inters (a b)
    (vl-remove-if-not
      (function (lambda (x)
                  (vl-position x a)
                )
      )
      b
    )
  )|;
  ;;
  (defun unique (l)
    (if l (cons (car l) (unique (vl-remove (car l) (cdr l)))))
  )
  ;;
  (defun _vl-sort ( lst func )
    (mapcar
      (function (lambda ( x ) (nth x lst)))
      (vl-sort-i lst func)
    )
  )
  ;;
  (defun _Pedal	 (p p1 p2)
    (inters p (polar p (+ _pi2 (angle p1 p2)) 1e3) p1 p2 nil))
  ;;  
  (defun suit-i	 (i k)
    (if	(not i%)
      (setq i% 0))
    (cond ((> i% n) (setq i% nil))
	  ((not (member i closed_il))
	   (setq i% nil)
	   i)
	  (t (setq i% (1+ i%)) (suit-i (format-i (k i) n) k))))
  ;|
  (defun used-si  (ti)
    (if	(and ti (setq ti (cons 11 ti)))
      (vl-remove
	nil
	(mapcar
	  (function (lambda (a)
		      (if (and (or (member ti (car a)) (member ti (cadr a)))
			       (not (assoc 70 a)))
			(dxf 10 (car a)))))
	  rgl))))|;
  ;;
  (defun pnth  (a)
    (cond ((= (car a) 10) (nth (cdr a) pl))
	  ((nth (cdr a) tl))))
  ;;
  (defun _get_minz  (a / i1 i2 z1 z2 z)
    (setq i1 (dxf 11 (car a))
	  i2 (dxf 11 (cadr a)))
    (cond ((and i1 i2)
	   (setq z1 (nth i1 zl)
		 z2 (nth i2 zl)
		 z  (min z1 z2)))
	  (i1 (setq z (nth i1 zl)))
	  (i2 (setq z (nth i2 zl)))))
  ;;
  (defun add-item  (ti an chain / a b c d)
    (setq a (car chain)
	  b (cadr chain)
	  c (cons 11 ti)
	  d (cons 12 an))
    (cond ((member c chain)
	   (while (not (equal (car chain) c))
	     (setq chain (cdr chain)))
	   (cond (an (cons (cons 12 an) chain))
		 (chain)) ;_More sides shared one vertex
	   )
	  ((and an (= (car a) 12))
	   (cons (cons 12 an) (cons (cons 11 ti) (cdr chain))))
	  ((and (not an) (= (car a) 12))
	   (cons (cons 11 ti) (cdr chain)))
	  ((= (car a) 11)
	   (cond ((= (cdr a) ti)
		  (cons (cons 12 an) chain))
		 ((equal (nth ti tl) (nth (cdr a) tl))
		  (cons (cons 12 an) chain))
		 (chain)))
	  (chain)))
  ;;
  (defun suit0	(p sil / si s p1 p2 p3 p4 p5 pp d ssl ssl sdl)
    ;; this suit function just determine p in the offset-line , and sure the point P is the top one .
    ;|(if (and *gsls_debug* (= (car sil) 13))
      (princ));_test|;
    (setq s  (nth (car sil) sl)
	  p1 (nth (car s) pl)
	  p2 (nth (cadr s) pl)
	  pp (_pedal p p1 p2)
	  d  (distance p pp))
    ;|(setq ssl (vl-remove-if (function (lambda (s)
					(member (car s) sil)))
			    sl))
    ;; if the point in the triangle {pa pb [i0~3]} which construct by the inzone side {pa pb}
    ;;                        and it's bisector rays inters with line {p p1} or line {p p2}  
    ;; S.M. of Invalid ray-inters of side {p1 p2}          	
    ;;	 	        p2___________p1                     	
    ;;  	         \i1       /                       	
    ;; 		        /\      /              		
    ;;   	      /   \\   /               		
    ;;	      bi_a  /      \ \/i0                		
    ;; 	       |  /         \ /\bi_b           		
    ;;         |/            P   \             		
    ;;         pa-------------------pb           		
    (setq ssl
	   (mapcar
	     (function
	       (lambda (s / pa pb pc pd an1 an2 i0 i1 i2 i3 i0c i1c i2d i3d iz iz1 l a  p0 p01)
		 (setq pa  (nth (car s) pl)
		       pb  (nth (cadr s) pl)
		       an1 (dxf (car s) bl)
		       an2 (dxf (cadr s) bl)
		       pc (nth (car s) rel)
		       pd (nth (cadr s) rel)
		       i0c (inters p p1 pa pc nil)
		       i1c (inters p p2 pa pc nil)
		       i2d (inters p p1 pb pd nil)
		       i3d (inters p p2 pb pd nil)
		       l (list i0c i1c i2d i3d)
		       iz1 (> (pipl? p (list pa pb pd pc) *gsls_angfuzz*) 0))	
		 (and iz1 (vl-some (function (lambda (x) (and x (not (equal x p *gsls_disfuzz*))))) l))))
	     ssl))|;
    (if (and ;|(apply (function =) (cons nil ssl))|;
	   ;_When there are continous intersections , it will delete effective vertex by mistake .
	    (progn (setq p3 (nth (cadr sil) pl) p4 (nth (cadr sil) rel) p5 (inters p1 p p3 p4))
	      (if (and *gsls_debug* (= (car sil) 13)) (entmake (list (cons 0 "line") (cons 10 p3) (cons 11 p4))))
		   (or (not p5) (equal p5 p *gsls_disfuzz*)))
	    (progn (setq p3 (nth (format-i (1+ (caddr sil)) n) pl) p4 (nth (format-i (1+ (caddr sil)) n) rel) p5 (inters p2 p p3 p4))
	      (if (and *gsls_debug* (= (car sil) 13)) (entmake (list (cons 0 "line") (cons 10 p3) (cons 11 p4))))
		 (or (not p5) (equal p5 p *gsls_disfuzz*))
		   ))         
       (progn
	 (setq sdl
		(mapcar
		  (function
		    (lambda (s / p1 p2 an1 an2 pp)
                      (if (and (nth (car s) pl) (nth (cadr s) pl) (dxf (car s) bl) (dxf (cadr s) bl))
                        (progn
		      (setq p1	(nth (car s) pl)
			    p2	(nth (cadr s) pl)
			    an1	(dxf (car s) bl)
			    an2	(dxf (cadr s) bl)
			    pp	(_pedal p p1 p2))
		      (if
			(or (member (car s) sil)
			    (and pp
				 (equal	(distance p1 p2)
					(+ (distance p1 pp) (distance p2 pp))
					*gsls_disfuzz*))
                            (and p p1 an1 p2 an2
			    (inzone? p p1 an1 p2 an2)))
			 (distance p pp)
			 (min (distance p p1) (distance p p2)))))))
		  sl))
	 (setq sdl (_vl-sort sdl (function <))) ;_sort z value	 
	 (setq sdl (vl-remove nil (list (car sdl) (cadr sdl) (caddr sdl)))) ;_if has not three value , 
	 (if
	   (not
	     (vl-some (function (lambda (d1) (not (equal d d1 *gsls_disfuzz*))))
		      sdl))
	    (/ (apply (function +) sdl) (length sdl))))) ;_return z
    )
  ;; 
  (defun suit  (p sil / si s p1 p2 pp d sdl)
    ;; this suit function just determine p in the offset-line , not sure the point P is the top one .
    (setq s  (nth (car sil) sl)
	  p1 (nth (car s) pl)
	  p2 (nth (cadr s) pl)
	  pp (_pedal p p1 p2)
	  d  (distance p pp))
    (setq sdl
	   (mapcar
	     (function
	       (lambda (s /  p1 p2 a  pa pb an1 an2 pp)
                 (if (and (nth (car s) pl) (nth (cadr s) pl) (nth (car s) rgl) (cadar (nth (car s) rgl)) (cadadr (nth (car s) rgl)))
                   (progn
		 (setq p1  (nth (car s) pl)
		       p2  (nth (cadr s) pl)
		       a   (nth (car s) rgl)
		       pa  (pnth (cadar a))
		       pb  (pnth (cadadr a))
		       an1 (cdaar a)
		       an2 (cdaadr a)
		       pp  (_pedal p p1 p2))
		 (if
		   (or (member (car s) sil)
		       (and pp
			    (equal (distance p1 p2)
				   (+ (distance p1 pp) (distance p2 pp))
				   *gsls_disfuzz*))
                       (and p pa an1 pb an2
		       (inzone? p pa an1 pb an2))
                       (and p pb an2 pa an1
		       (inzone? p pb an2 pa an1)))
		    (distance p pp)
		    (min (distance p p1) (distance p p2)))))))
	     (vl-remove-if (function (lambda (x) (member (car x) closed_il))) sl) ;_remove closed side
	     ))
    (setq sdl (_vl-sort sdl '<)
	  sdl (vl-remove nil (list (car sdl) (cadr sdl) (caddr sdl))))
    (if
      (not
	(vl-some (function (lambda (d1) (not (equal d d1 *gsls_disfuzz*)))) sdl))
       (/ (apply (function +) sdl) (length sdl))) ;_return z
    )
  ;;
  (defun suit1	(p sil / si s p1 p2 pp d i ssl sdl)
    ;; this suit function just determine p in the offset-line , not sure the point P is the top one .
    (setq s  (nth (car sil) sl)
	  p1 (nth (car s) pl)
	  p2 (nth (cadr s) pl)
	  pp (_pedal p p1 p2)
	  d  (distance p pp))
    (setq sdl
	   (mapcar
	     (function
	       (lambda (s / p1 p2 a pa pb an1 an2 pp)
                 (if (and (nth (car s) pl) (nth (cadr s) pl) (nth (car s) rgl) (cadar (nth (car s) rgl)) (cadadr (nth (car s) rgl)))
                   (progn
		 (setq p1  (nth (car s) pl)
		       p2  (nth (cadr s) pl)
		       a   (nth (car s) rgl)
		       pa  (pnth (cadar a))
		       pb  (pnth (cadadr a))
		       an1 (cdaar a)
		       an2 (cdaadr a)
		       pp  (_pedal p p1 p2))
		 (if
		   (or (member (car s) sil)
		       (and pp
			    (equal (distance p1 p2)
				   (+ (distance p1 pp) (distance p2 pp))
				   *gsls_disfuzz*))
                       (and p pa an1 pb an2
                       (inzone? p pa an1 pb an2))) ;_here must use last fan-shaped zone of side 
		    (distance p pp)
		    (min (distance p p1) (distance p p2)))))))
	     (mapcar (function (lambda (i) (nth i sl))) sil)))
    (setq sdl (_vl-sort sdl '<)
	  sdl (vl-remove nil (list (car sdl) (cadr sdl) (caddr sdl))))
    (if
      (not
	(vl-some (function (lambda (d1) (not (equal d d1 *gsls_disfuzz*)))) sdl))
       (/ (apply (function +) sdl) (length sdl)))) ;_return z
  ;; check closed
  (defun _closed  () ;_(_closed) rgl
    (if	t
      (setq rgl
	     (mapcar
	       (function
		 (lambda (r / a b c d e)
		   (setq a (car r)
			 b (cadr r)
			 c (caddr r))
		   (cond
		     (c r)
		     ((and (setq d (assoc 11 a)) (setq e (assoc 11 b)) (equal d e))
		      (setq closed_n  (1+ closed_n)
			    closed_il (cons (dxf 10 a) closed_il))
		      (list (member d a) (member e b) (cons 70 1)))
		     ((list a b)))))
	       rgl))))
  ;;
  (defun _closed2 ( /  il a a1 a2 an1 an2 p1 p2)
    (if (and t
	     (setq il (vl-remove-if (function (lambda (i)
					   (_vl-position i closed_il 1e-6 nil)))
			       (mapcar (function car) bl))))
      (foreach i il
        (if (and (cadr (car (nth i rgl))) (cadr (cadr (nth i rgl))))
          (progn
	(setq a (nth i rgl)
	      a1 (car a)
	      a2 (cadr a)
	      an1 (cdar a1)
	      an2 (cdar a2)
	      p1 (pnth (cadr a1))
	      p2 (pnth (cadr a2)))
	(if (and (equal (angle p1 p2) an1 1e-3)
		 (equal (angle p2 p1) an2 1e-3))	 
	    (cond ((= (caadr a1) 10)
		 (setq a1 (cons (cadr a2) (cdr a1))
		       a2 (cdr a2)
		       rgl (subst (list a1 a2 (cons 70 1)) a rgl)))
		(t (setq a2 (cons (cadr a1) (cdr a2))
			 a1 (cdr a1)
			 rgl (subst (list a1 a2 (cons 70 1)) a rgl))))))))))	
;;; current used function 
  (defun _getclosed  ()
    (if
      (and t
	   (setq
	     rdl (vl-remove-if-not
		   (function
		     (lambda (a / i)
		       (and (assoc 70 a)
			    (setq i (dxf 10 (car a)))
			    ;_(not (assoc 70 (nth (format-i (1+ i) n) rgl)))
			    ;_(not (assoc 70 (nth (format-i (1- i) n) rgl)))
			    (not (member (format-i (1+ i) n) closed_il))
			    (not (member (format-i (1- i) n) closed_il))
			    )
		       ))
		   rgl)))
       (setq
	 rdl (mapcar
	       (function (lambda (a)
			   (list (_get_minz a) a)))
	       rdl)
	 rdl (_vl-sort rdl
		      (function	(lambda	(a b)
				  (< (car a) (car b))))))))
  ;; Get closed info of side 
  (defun _getclosedinfo	 (bi fi / ip0 ip1 ab cf bii fii p p0 p1 ip j0 j1 z) ;_(_getclosedinfo 5 57)
    (defun f1  (/ ab p0 p01 abb pab anb)
      (and (setq z
		  (suit	ip0
			(list bi (suit-i (format-i (1- bi) n) 1-) fi)))
	   (or (not bii)
	       (and (= bii (1- bi)) ;_neighbor is always inzone .
		    (not ;_neighbor no closed first .
		      (and (assoc 70 (nth (format-i (1- bii) n) rgl))
			   (setq ab (nth bii rgl))
                           (cadar ab)
			   (setq pab (pnth (cadar ab)))
			   (setq anb (cdaar ab))
                           (assoc 10 (cadr ab))
			   (setq p0 (ray-int-line pab  anb   (pnth (assoc 10 (cadr ab)))  ip0))
			   (not (equal ip0 p0 *gsls_disfuzz*))
			   ;; ray can reached .
			   (setq abb (nth (suit-i (format-i (1- bii) n) 1-) rgl))
                           (cadar abb)
			   (or (not (setq p01 (ray-inters  pab anb (pnth (cadar abb)) (cdaar abb))))
			       (< (distance pab p0) (distance pab p01)))				 
			   )))
               (if
               (and ip0 (cadar (setq ab (nth bii rgl))) (cdaar ab) (cadadr ab) (cdaadr ab))
               (inzone?	ip0
			(pnth (cadar (setq ab (nth bii rgl))))
			(cdaar ab)
			(pnth (cadadr ab))
			(cdaadr ab))
               )
	       ;; add reverse zone line , June 24 , 2014
               (if
               (and ip0 (cadadr (setq ab (nth bii rgl))) (cdaadr ab) (cadar ab) (cdaar ab))
	       (inzone?	ip0
			(pnth (cadadr (setq ab (nth bii rgl))))
			(cdaadr ab)
			(pnth (cadar ab))
			(cdaar ab))
               )
	       )))
    (defun f2  (/ cf p1 p11 pcf anf cff)
      (and (setq z
		  (suit	ip1
			(list fi (suit-i (format-i (1+ fi) n) 1+) bi)))
	   (or (not fii)
	       (and (= fii (1+ fi)) ;_neighbor is always inzone .
		    (not ;_neighbor no closed first .
		      (and (assoc 70 (nth (format-i (1+ fii) n) rgl))
			   (setq cf (nth fii rgl))
                           (cadadr cf)
			   (setq pcf (pnth (cadadr cf)))
			   (setq anf (cdaadr cf))
                           (assoc 10 (car cf))
			   (setq p1 (ray-int-line pcf
						  anf
						  (pnth (assoc 10 (car cf)))
						  ip1))
			   (not (equal ip1 p1 *gsls_disfuzz*))
			   ;; ray can reached .
			   (setq cff (nth (suit-i (format-i (1+ fii) n) 1+) rgl))
                           (cadadr cff)
			   (or (not (setq p11 (ray-inters pcf anf (pnth (cadadr cff)) (cdaadr cff))))
			       (< (distance pcf p1) (distance pcf p11)))
			   )))
               (if
               (and ip1 (cadar (setq cf (nth fii rgl))) (cdaar cf) (cadadr cf) (cdaadr cf))
	       (inzone?	ip1
			(pnth (cadar (setq cf (nth fii rgl))))
			(cdaar cf)
			(pnth (cadadr cf))
			(cdaadr cf))
               )
	       ;; add reverse zone line , June 24 , 2014
               (if
               (and ip1 (cadadr (setq cf (nth fii rgl))) (cdaadr cf) (cadar cf) (cdaar cf))
	       (inzone?	ip1			
			(pnth (cadadr (setq cf (nth fii rgl))))
			(cdaadr cf)
			(pnth (cadar cf))
			(cdaar cf))
               )
	       )))
    (if
      (and
	t
	(/= bi fi)
	(setq a (nth bi rgl));_??????,?????????????????,?????
	(setq c (nth fi rgl))
	;|(if (equal (list bi fi) '(80 13))
	  (progn T)
	  T) ;_for test|;
	(not (assoc 70 a))
	(not (assoc 70 c))
        (cadadr a)
        (cadar a)
        (cadar c)
        (cadadr c)
	(vl-remove nil
		   (list (setq ip0 (ray-inters (pnth (cadadr a))
					       (cdaadr a)
					       (pnth (cadar a))
					       (cdaar a)))
			 (setq ip1 (ray-inters (pnth (cadar c))
					       (cdaar c)
					       (pnth (cadadr c))
					       (cdaadr c)))
			 (progn
			   (setq bii
				  (if
				    (not
				      (member (setq bii (suit-i (format-i (1- bi) n) 1-))
					      (list bi fi)))
				     bii))
			   (setq fii
				  (if
				    (not
				      (member (setq fii (suit-i (format-i (1+ fi) n) 1+))
					      (list bi fi)))
				     fii))
			   nil)))
	(setq p (pnth (cadar c)));_(entmake (list (cons 0 "POINT") (cons 10 ip1) (cons 62 2)))
	(setq ip
	       (cond
		 ((and ip0 ip1)
		  (cond
		    ((and (> (setq j0 (pipl? ip0 pl *gsls_angfuzz*)) 0)
			  (> (setq j1 (pipl? ip1 pl *gsls_angfuzz*)) 0))
		     (cond ((<= (distance p ip0) (distance p ip1))
			    (if	(f1)
			      (list "back" ip0 z)))
			   ((if	(f2)
			      (list "for" ip1 z)))))
		    ((> (setq j0 (pipl? ip0 pl *gsls_angfuzz*)) 0)
		     (if (f1)
		       (list "back" ip0 z)))
		    ((> (setq j1 (pipl? ip1 pl *gsls_angfuzz*)) 0)
		     (if (f2)
		       (list "for" ip1 z)))))
		 ((and ip0 (> (setq j0 (pipl? ip0 pl *gsls_angfuzz*)) 0))
		  (if (f1)
		    (list "back" ip0 z)))
		 ((and ip1 (> (setq j1 (pipl? ip1 pl *gsls_angfuzz*)) 0))
		  (if (f2)
		    (list "for" ip1 z))))))
       (append ip (list bi fi))))
  ;; colsed side can be closed  
  (defun _closeditself	(ip / ty)
    ;; ip = ( "for/back" ip1/ip0 z bi fi)
    (setq ty (car ip)
	  p  (cadr ip)
	  z  (caddr ip)
	  bi (cadddr ip)
	  fi (last ip)
	  a  (nth bi rgl)
	  c  (nth fi rgl))    
    (if	(and (not (member bi closed_il)) (not (member fi closed_il)))
      (progn
	(if (not (setq i (_vl-position p tl 1e-6 nil)))
	  (setq	tl (append tl (list p))
		zl (append zl (list (caddr ip)))
		i  (1- (length tl))))
	(cond ((= ty "for")
	       (setq c1	       (list (add-item i nil (car c))
				     (add-item i nil (cadr c))
				     (cons 70 1))
		     rgl       (subst c1 c rgl)
		     closed_n  (1+ closed_n)
		     closed_il (cons (dxf 10 (car c)) closed_il) ;_(vl-maxtimes closed_il)
		     fi	       (format-i (1+ fi) n))
	       (if (= (suit-i (format-i fi n) 1+) bi)
		 (setq a1	 (list (add-item i nil (car a))
				       (add-item i nil (cadr a))
				       (cons 70 1))
		       rgl	 (subst a1 a rgl)
		       closed_n	 (1+ closed_n)
		       closed_il (cons (dxf 10 (car a)) closed_il))
		 (if (and (setq c (nth (suit-i (format-i fi n) 1+) rgl)) (assoc 10 (car c)) (assoc 10 (cadr c)) (assoc 10 (car a)) (assoc 10 (cadr a)))
		   (setq p2  (pnth (assoc 10 (car c)))
			 p3  (pnth (assoc 10 (cadr c)))
			 p0  (pnth (assoc 10 (car a)))
			 p1  (pnth (assoc 10 (cadr a)))
			 an  (bisector2 p0 p1 p2 p3)
			 rgl (cond
			       ((assoc 70 a) rgl)
			       ((subst (list (car a) (add-item i an (cadr a))) a rgl)))
			 rgl (cond
			       ((assoc 70 c) rgl)
			       ((subst (list (add-item i an (car c)) (cadr c)) c rgl)))
			 ))))
	      ((= ty "back")
	       (setq a1	       (list (add-item i nil (car a))
				     (add-item i nil (cadr a))
				     (cons 70 1))
		     rgl       (subst a1 a rgl)
		     closed_n  (1+ closed_n)
		     closed_il (cons (dxf 10 (car a)) closed_il)
		     bi	       (format-i (1- bi) n))
	       (if (= (suit-i (format-i bi n) 1-) fi)
		 (setq c1	 (list (add-item i nil (car c))
				       (add-item i nil (cadr c))
				       (cons 70 1))
		       rgl	 (subst c1 c rgl)
		       closed_n	 (1+ closed_n)
		       closed_il (cons (dxf 10 (car c)) closed_il))
		 (if (and (setq a (nth (suit-i (format-i bi n) 1-) rgl)) (assoc 10 (car c)) (assoc 10 (cadr c)) (assoc 10 (car a)) (assoc 10 (cadr a)))
		   (setq p2  (pnth (assoc 10 (car c)))
			 p3  (pnth (assoc 10 (cadr c)))
			 p0  (pnth (assoc 10 (car a)))
			 p1  (pnth (assoc 10 (cadr a)))
			 an  (bisector2 p0 p1 p2 p3)
			 rgl (cond
			       ((assoc 70 a) rgl)
			       ((subst (list (car a) (add-item i an (cadr a))) a rgl)))
			 rgl (cond
			       ((assoc 70 c) rgl)
			       ((subst (list (add-item i an (car c)) (cadr c)) c rgl)))
			 )))))
	(_closed)))
    (setq bi (suit-i (format-i bi n) 1-)
	  fi (suit-i (format-i fi n) 1+)))
  ;; get closed side neighbor 
  (defun _getneighbor  ()
    (setq
      rnl (vl-remove-doubles
	    (vl-remove
	      nil
	      (mapcar (function	(lambda	(r / sti bi fi)
				  (setq sti (dxf 10 (caadr r)))
				  (setq	fi (suit-i (format-i (1+ sti) n) 1+)
					bi (suit-i (format-i (1- sti) n) 1-))
				  (_getclosedinfo bi fi)))
		      rdl)))
      rnl (_vl-sort rnl
		   (function (lambda (a b)
			       (< (caddr a) (caddr b)))))))
  ;; get single no closed
  (defun _getsinglenoclosed (/ il)
    (setq il (mapcar (function car) bl))
    (foreach i	closed_il
      (setq il (vl-remove i il)))
    (vl-remove-if-not
		   (function (lambda (i)
			       (and (member (format-i (1- i) n) closed_il)
				    (member (format-i (1+ i) n) closed_il))))
		   il)    )    
  ;; get no closed side neighbor
  (defun _getnoclosedpair  (/ il)    
    (if	(setq il (vl-remove-if (function (lambda (i)
				       (_vl-position i closed_il 1e-6 nil)))
			   (mapcar (function car) bl))) 
	(setq il (vl-remove-if-not
		   (function (lambda (i)
			       (not (member (format-i (1+ i) n) il))))
		   il)
	      il (mapcar (function (lambda (i)
				     (list i (suit-i (1+ i) 1+))))
			 il)
	      il   (_vl-sort	 il	 (function	   (lambda (a b)
		     (<	(apply (function min)
			       (vl-remove				 nil
				 (mapcar (function (lambda (i)
						     (_get_minz (nth i rgl))))					 a)))
			(apply (function min)
			       (vl-remove				 nil
				 (mapcar (function (lambda (i)
						     (_get_minz (nth i rgl))))
					 b))))))))))
  ;;
  (defun _getnoclosdedpairinfo	()
    (setq rnl (vl-remove nil
			 (mapcar (function (lambda (a)
					     (apply (function _getclosedinfo) a)))
				 (_getnoclosedpair)))
	  rnl (_vl-sort rnl
		       (function (lambda (a b)
				   (< (caddr a) (caddr b)))))))
;;;--------------------------------------------------------------------
  (defun foo  ()
    (_getclosed)
    (_getneighbor)
    (while (and t rnl)
      (foreach ip  rnl
	(if t
	  (progn (_closeditself ip)
		 (while	(and t (setq ip (_getclosedinfo bi fi)))
		   (_closeditself ip)) )))
      (_getclosed)
      (_getneighbor))
    )
;;;--------------------------------------------------------------------
  (defun foo1  ()
    (_getnoclosdedpairinfo)
    (while (and t rnl)
      (foreach ip  rnl
	(if t
	  (progn (_closeditself ip)
		 (while	(and t (setq ip (_getclosedinfo bi fi)))
		   (_closeditself ip)) )  ))
      (_getnoclosdedpairinfo)))  
;;;--------------------------------------------------------------------
  ;;
  (defun dxf (a l)
    (cdr (assoc a l))
  )
  ;; (_vl-position 3.29 '(1.1 2.2 3.3 4.4 5.5 6.6 7.7 8.8 9.9) 0.01 nil) => 2 (!k => nil) ;;
  (defun _vl-position (e l tol k)
    (if (null k)
      (setq k 0)
    )
    (if (not (equal e (car l) tol))
      (progn
        (setq k (1+ k))
        (if (cdr l)
          (_vl-position e (cdr l) tol k)
          (setq k nil)
        )
      )
      k
    )
  )
  ;;
  (defun ang-equal (a b eps)
    (equal (cond ((equal a _2pi eps) 0.0)
                 (a)
           )
           (cond ((equal b _2pi eps) 0.0)
                 (b)
           )
           eps
    )
  )
  ;;
  (defun ray-inters (p0 an0 p1 an1 / p)
    ;; intersection of two ray line 
    ;; an0 an1 -- [0 2pi)
    ;; add deal angles  2pi equal 0
    ;; by GSLS(SS) May , 2014 
    (cond
      ((ang-equal (angle p0 p1) an0 *gsls_angfuzz*) p1)
      ((ang-equal (angle p1 p0) an1 *gsls_angfuzz*) p0)
      ((and (setq p (inters p0
                            (polar p0 an0 1000.)
                            p1
                            (polar p1 an1 1000.)
                            nil
                    )
            )
            (ang-equal (angle p0 p) an0 *gsls_angfuzz*)
            (ang-equal (angle p1 p) an1 *gsls_angfuzz*)
       )
       p
      )
    )
  )
  ;;
  (defun L_INT_PL (p1 p2 l / p res)
    (mapcar (function (lambda (p3 p4)
                        (if (setq p (inters p1 p2 p3 p4 T))
                          (setq res (cons p res))
                        )
                      )
            )
            l
            (cdr l)
    )
    res
  )
  ;;
  (defun ray-int-line (p0 an0 p1 p2 / p)
    ;; intersection of two ray line 
    ;; an0 an1 -- [0 2pi)
    ;; add deal angles  2pi equal 0
    ;; by GSLS(SS) May , 2014 
    (cond
      ((ang-equal (angle p0 p1) an0 *gsls_angfuzz*) p1)
      ((ang-equal (angle p0 p2) an0 *gsls_angfuzz*) p2)
      ((and
         (setq p (inters p0 (polar p0 an0 1000.) p1 p2 nil))
         (ang-equal (angle p0 p) an0 *gsls_angfuzz*)
         (equal (distance p1 p2)
                (+ (distance p p1) (distance p p2))
                *gsls_disfuzz*
         )
       )
       p
      )
    )
  )
  ;;
  (defun bisector (p0 p1 p2 / d a a0)
    ;; Get inter bisector of counterclockwise point set
    ;; p0 p1 p2 -- 3p of ccw polygon
    ;; return inter-bisector in [0 2pi)
    ;; by GSLS(SS) May , 2014 
    (setq d (distance p0 p1)
          a (- (setq a0 (angle p1 p0)) (angle p1 p2))
          a (- a0
               (/ (angle '(0 0) (list (* d (cos a)) (* d (sin a)))) 2.)
            )
    )
    (cond ((< a 0) (+ a _2pi))
          ((>= a _2pi) (- a _2pi))
          (a)
    )
  )
  ;;
  (defun bisector2 (p0 p1 p2 p3)
    ;; Get inter bisector between line (p1 p0) with line (p2 p3) 
    ;; p0 p1 p2 p4-- 4p of ccw polygon
    ;; return inter-bisector in [0 2pi)
    ;; by GSLS(SS) May , 2014 
    (setq p0 (mapcar (function +) (mapcar (function -) p2 p1) p0))
    (if
      (<= (car (trans (mapcar (function -) p0 p3)
                      0
                      (mapcar (function -) p2 p3)
               )
          )
          0
      )
       (bisector p0 p2 p3)
       (bisector p3 p2 p0)
    )
  )
  ;;-----------------------------------------------------
  (defun lbisector (l / i)
    (setq i -1)
    (mapcar (function (lambda (p0 p1 p2)
                        (setq i (1+ i))
                        (cons i (bisector p0 p1 p2))
                      )
            )
            (cons (last l) l)
            l
            (append (cdr l) (list (car l)))
    )
  )
  ;;
  (defun format-i (i n)
    (cond ((< i 0) (+ n i))
          ((>= i n) (- i n))
          (i)
    )
  )
;;;------------------------------------------------------------------------------;;;
;;; determine p in the zone build with a line {p0 p1} and two rays -- ray0 {p0 an0} ,
;;;    ray1 {p1 an1},  the zone is clockwise scan from ray0 to ray1 .
;;; Legend :
;;;  an0\+++++++++++/an1   
;;;      \++++p++++/       
;;;       \+++++++/        
;;;        p0---p1
;;; args :
;;;      p  -- a given point to determine whether in zone
;;;      p0 -- line's start point , also should be the ray0's source point .
;;;      an0 -- angle of the ray0
;;;      p1 -- line's end point , also should be the ray1's source point .
;;;      an1 -- angle of the ray1 
  (defun inzone? (p p0 an0 p1 an1 / a an2 an3 d)
    (defun f (a)
      (cond ((< a 0) (+ a _2pi))
            (a)
      )
    )
    (setq a   (angle p0 p1)
          an0 (f (- an0 a))
          an1 (f (- an1 a))
          an2 (f (- (angle p0 p) a))
          an3 (f (- (angle p1 p) a))
          d   (car (trans (mapcar (function -) p p1)
                          0
                          (mapcar (function -) p0 p1)
                   )
              )
    )
    (and (<= an2 (+ an0 *gsls_angfuzz*))
         (>= an3 (- an1 *gsls_angfuzz*))
         (< d 0)
    )
  )
  ;;
;;;Function : judge a point location with polygon
;;;Arg : pt -- a point
;;;      pts -- points of polygon
;;;      eps -- allowance
;;;return :
;;;     -1 -- out of polygon , 0 -- at , 1 -- in
  (defun pipl? (pt pts eps / is at a)
    ;; by Jueao Sword  
    ;; Edit by GSLS(SS) 2011.03.28
    ;; Solved the problem : if a point at the given polygon , it perhap return T or NIL .  
    (cond
      ((vl-some (function (lambda (x) (equal x pt eps))) pts) 0)
      ((and
         (equal
           (abs
             (apply
               (function +)
               (mapcar
                 (function
                   (lambda (x y / a)
                     (setq a (rem (- (angle pt x) (angle pt y)) PI))
                     (if (equal (+ (distance pt x) (distance pt y))
                                (distance x y)
                                *gsls_disfuzz*
                         )
                       (setq at T)
                     )
                     a
                   )
                 )
                 (cons (last pts) pts)
                 pts
               )
             )
           )
           pi
           eps
         )
         (not at)
       )
       1
      )
      (at 0)
      (-1)
    )
  )
  ;; get closed polygon's area
  (defun ss-pts2area (l)
    (/
      (apply
        (function +)
        (mapcar (function (lambda (x y)
                            (- (* (car x) (cadr y)) (* (car y) (cadr x)))
                          )
                )
                (cons (last l) l)
                l
        )
      )
      2.
    )
  )
  ;; round
  (defun round (a jd / b s)
    ;; a -- a number or a number list,
    ;; jd -- Precision digits , decimal is a positive , integer is negative
    ;; e.g. (round 3.14159 3) --> 3.142 , (round 314159 -3) --> 314200
    ;;      (round '(2.567 3.141) 2) --> '(2.57 3.14)
    ;; by GSLS(SS) May , 2014 
    (cond ((numberp a)
           (setq b (expt 10.0 jd)
                 s (sign a)
           )
           (/ (fix (+ (* a b) (* 0.5 s))) b)
          )
          ((listp a)
           (mapcar (function (lambda (a) (round a jd))) a)
          )
    )
  )
  ;;
  (defun sign (x)
    (cond ((minusp x) -1.)
          (1.0)
    )
  )
  ;;
  (defun eqmember (p l eps)
    (cond ((not l) nil)
          ((if (numberp eps)
             (equal p (car l) eps)
             (equal p (car l))
           )
           l
          )
          ((eqmember p (cdr l) eps))
    )
  )
  ;;
  (defun remove-same-pts (lst tor / l)
    (if lst
      (foreach a lst
        (if (not (eqmember a l tor))
          (setq l (cons a l))
        )
      )
    )
    (reverse l)
  )
  ;;
  (defun vl-remove-doubles (lst)
    (if lst
      (cons (car lst)
            (vl-remove-doubles (vl-remove (car lst) lst))
      )
    )
  )
  ;;
  (defun remove-nth (i lst / j len fst)
    ;; by GSLS(SS)
    (if (/= (type i) (quote list))
      (cond
        ((or (minusp i) (> i (1- (setq len (length lst)))))
         lst
        )
        ((> i (/ len 2))
         (reverse (remove-nth (1- (- len i)) (reverse lst)))
        )
        (t
         (append
           (progn
             (setq fst nil)
             (repeat (rem i 4)
               (setq fst (cons (car lst) fst)
                     lst (cdr lst)
               )
             )
             (repeat (/ i 4)
               (setq fst (vl-list* (cadddr lst)
                                   (caddr lst)
                                   (cadr lst)
                                   (car lst)
                                   fst
                         )
                     lst (cddddr lst)
               )
             )
             (reverse fst)
           )
           (cdr lst)
         )
        )
      )
      (progn
        (setq j (cadr i)
              i (car i)
        )
        (if j
          (mapcar (function (lambda (x) (remove-nth j x)))
                  (remove-nth i lst)
          )
          (remove-nth i lst)
        )
      )
    )
  )
  ;;
  (defun TCGroup (l / sej a c r)
    ;; Cycle Group of a list split by nil-items 
    ;; (TCGroup '(nil 1 2 3 nil nil 4 5 6 nil 7))-> '((1 2 3) (4 5 6) (7))
    ;; (TCGroup '(1 2 nil 3 4 5 nil 6)) -> '((6 1 2) (3 4 5))
    (if (and (car l) (last l))
      (setq sej T)
    )
    (while l
      (setq a (car l)
            l (cdr l)
      )
      (if (and a (setq c (list a)))
        (while (car l)
          (setq c (cons (car l) c)
                l (cdr l)
          )
        )
        (setq c nil)
      )
      (if c
        (setq r (cons (reverse c) r))
      )
    )
    (if sej
      (cons (append (car r) (last r)) (cdr (reverse (cdr r))))
      (reverse r)
    )
  )
  ;;
  (defun eqgroup (l f eps / a c r)
    ;; join neighbor element's value get by function f is equal by pricision eps into a group
    ;; (eqgroup '((1 2) (1 3)  (2 3)  (3 4)  (5 4)) cadr 1e-3)-->'(((1 2)) ((1 3) (2 3)) ((3 4) (5 4)))
    ;; (eqgroup '((1 2) (1 3)  (2 3)  (3 4)  (5 4)) car 1e-3) -->'(((1 2) (1 3)) ((2 3)) ((3 4)) ((5 4)))
    (while l
      (setq a (car l)
            l (cdr l)
            c (list a)
      )
      (while (equal (f a) (f (car l)) eps)
        (setq c (cons (car l) c)
              l (cdr l)
        )
      )
      (setq r (cons (reverse c) r))
    )
    (reverse r)
  )
  ;;
  (defun assoc2 (n l / a)
    (if (setq a (assoc n l))
      (list a (cadr (member a l)))
    )
  )
  ;;
  ;;------------------------------------------------------------;;
  ;;  Author: Lee Mac, Copyright ?2011 - www.lee-mac.com        ;;
  ;;------------------------------------------------------------;;
  ;;  Arguments:                                                ;;
  ;;  ent - Entity for which to return Point List.              ;;
  ;;------------------------------------------------------------;;
  ;;  Returns:  List of Points describing/approximating entity  ;;
  ;;------------------------------------------------------------;;
  (defun LM:Entity->PointList
         (ent / der di1 di2 di3 elst inc lst par rad)
    (setq elst (entget ent))
    (cond
      ((eq "POINT" (dxf 0 elst))
       (list (dxf 10 elst))
      )
      ((eq "LINE" (dxf 0 elst))
       (list (dxf 10 elst) (dxf 11 elst))
      )
      ((member (dxf 0 elst) (list "CIRCLE" "ARC"))
       (setq di1 0.0
             di2 (vlax-curve-getdistatparam
                   ent
                   (vlax-curve-getendparam ent)
                 )
             inc (/
                   di2
                   (1+ (fix (* 35.0 (/ di2 (dxf 40 elst) (+ pi pi))))
                   )
                 )
             fun (if (vlax-curve-isclosed ent)
                   <
                   <=
                 )
       )
       (while (fun di1 di2)
         (setq lst (cons (vlax-curve-getpointatdist ent di1) lst)
               di1 (+ di1 inc)
         )
       )
       lst
      )
      ((or (eq (dxf 0 elst) "LWPOLYLINE")
           (and (eq (dxf 0 elst) "POLYLINE")
                (zerop (logand (dxf 70 elst) 80))
           )
       )
       (setq par 0)
       (repeat (fix (1+ (vlax-curve-getendparam ent)))
         (if (setq der (vlax-curve-getsecondderiv ent par))
           (if (equal der (list 0.0 0.0 0.0) 1e-8)
             (setq lst (cons (vlax-curve-getpointatparam ent par) lst))
             (if (setq rad (distance (list 0.0 0.0)
                                     (vlax-curve-getfirstderiv ent par)
                           )
                       di1 (vlax-curve-getdistatparam ent par)
                       di2 (vlax-curve-getdistatparam ent (1+ par))
                 )
               (progn
                 (setq
                   inc
                    (/ (- di2 di1)
                       (1+ (fix (* 35.0 (/ (- di2 di1) rad (+ pi pi)))))
                    )
                 )
                 (while (< di1 di2)
                   (setq lst (cons (vlax-curve-getpointatdist ent di1) lst)
                         di1 (+ di1 inc)
                   )
                 )
               )
             )
           )
         )
         (setq par (1+ par))
       )
       (if (or (vlax-curve-isclosed ent)
               (equal (list 0.0 0.0 0.0) der 1e-8)
           )
         lst
         (cons (vlax-curve-getendpoint ent) lst)
       )
      )
      ((eq (dxf 0 elst) "ELLIPSE")
       (setq di1 (vlax-curve-getdistatparam
                   ent
                   (vlax-curve-getstartparam ent)
                 )
             di2 (vlax-curve-getdistatparam
                   ent
                   (vlax-curve-getendparam ent)
                 )
             di3 (* di2
                    (/ (+ pi pi)
                       (abs (- (vlax-curve-getendparam ent)
                               (vlax-curve-getstartparam ent)
                            )
                       )
                    )
                 )
       )
       (while (< di1 di2)
         (setq lst (cons (vlax-curve-getpointatdist ent di1) lst)
               der (distance (list 0.0 0.0)
                             (vlax-curve-getsecondderiv
                               ent
                               (vlax-curve-getparamatdist ent di1)
                             )
                   )
               di1 (+ di1 (/ di3 (1+ (fix (/ 35.0 (/ di3 der (+ pi pi)))))))
         )
       )
       (if (vlax-curve-isclosed ent)
         lst
         (cons (vlax-curve-getendpoint ent) lst)
       )
      )
      ((eq (dxf 0 elst) "SPLINE")
       (setq di1 (vlax-curve-getdistatparam
                   ent
                   (vlax-curve-getstartparam ent)
                 )
             di2 (vlax-curve-getdistatparam
                   ent
                   (vlax-curve-getendparam ent)
                 )
             inc (/ di2 25.0)
       )
       (while (< di1 di2)
         (setq lst (cons (vlax-curve-getpointatdist ent di1) lst)
               der (/ (distance (list 0.0 0.0)
                                (vlax-curve-getsecondderiv
                                  ent
                                  (vlax-curve-getparamatdist ent di1)
                                )
                      )
                      inc
                   )
               di1 (+ di1
                      (if (equal 0.0 der 1e-10)
                        inc
                        (min inc (/ 1.0 der (* 10. inc)))
                      )
                   )
         )
       )
       (if (vlax-curve-isclosed ent)
         lst
         (cons (vlax-curve-getendpoint ent) lst)
       )
      )
    )
  )
  ;;
  (defun midpt (p1 p2)
    (mapcar (function (lambda (x y) (/ (+ x y) 2.))) p1 p2)
  )
  ;;
  ;;------------------------------------main function------------------------------;;

  (defun start (pl    /     a     a1    ab    an    b     bi    bii
                bl    c     c1    cf    closed_il   closed_n    d
                e     fi    fii   i     i%    il    ip0   ip1   li
                ll    n     p     p0    p1    p2    p3    rdl   rgl
                i%%   rml   rnl   sil   sl    ti    tl    z     zl
                rel   pl1   b1    i+    i-    crl   cr    a0    a2
                a3    ill   rgl11 tst11 ;_local variables
               )

    (setq _2pi           6.283185307179586476925286766559
          _pi2           1.5707963267948966192313216916395
          *gsls_angfuzz* 1e-7
          *gsls_disfuzz* 1e-3
          *gsls_debug*
                         nil
    )
    
    (if (< (ss-pts2area pl) 0) ;_force pointset CCW
      (setq pl (reverse pl))
    )

    ;; build side message 
    (setq n (length pl)
          i -1
    )
    (setq sl (mapcar (function (lambda (a)
                                 (setq i (1+ i))
                                 (if (= (1+ i) n)
                                   (list i 0)
                                   (list i (1+ i))
                                 )
                               )
                     )
                     pl
             )
    )
    ;; build inter-bisector angle list with point index 
    (setq bl (lbisector pl))
    ;; for test
    (if *gsls_debug* ;_(setq *gsls_debug* T)
      (mapcar (function (lambda (a / p p1)
                          (setq p  (nth (car a) pl)
                                p1 (polar p (cdr a) 500.)
                          )
                          (entmake (list (cons 0 "TEXT")
                                         (cons 10 p)
                                         (cons 1 (rtos (car a) 2 0))
                                         (cons 40 1000.)
                                         (cons 41 0.7)
                                         (cons 50 0.0)
                                   )
                          )
                          (entmake (list (cons 0 "LINE")
                                         (cons 10 p)
                                         (cons 11 p1)
                                         (cons 8 "TEST")
                                         (cons 62 3)
                                   )
                          )
                        )
              )
              bl
      )
    )
       ;; build start result list , each side with two construction list
       ;; dxf code : 10 -- point of pl , 11 -- point of tl (inter points) , 12 -- ray angle of last point  , 70 -- closed mark 
       (setq rgl
	      (mapcar
		(function
		  (lambda (s)
		    (list (list (cons 12 (cdr (nth (car s) bl))) (cons 10 (car s)))
			  (list (cons 12 (cdr (nth (cadr s) bl))) (cons 10 (cadr s))))))
		sl))
       ;; ray end point list
       (setq pl1 (append (cdr pl) (list (car pl))))
       (setq rel (mapcar (function (lambda (a / i ii p b p1)
				     (setq i (car a)
					   a (cdr a)
					   p (nth i pl)
					   b (list (format-i (1- i) n) i)
					   ii -1)					   
				     (setq p1
					    (car
					      (_vl-sort
						(vl-remove
						  nil
						  (mapcar
						    (function
						      (lambda (p0 p1)
						      (if (not(member (setq ii (1+ ii)) b))													
							(ray-int-line p a p0 p1))))
						    pl
						    pl1))
						(function (lambda (p0 p1)
							    (< (distance p0 p) (distance p1 p)))))))				     
				     (car (_vl-sort (vl-remove nil (list (midpt p p1)
						    (ray-inters p a (nth (car b) pl) (dxf (car b) bl))
						    (ray-inters p a (nth (setq i (format-i (1+ i) n)) pl) (dxf i bl))))
					      (function (lambda (p0 p1)
							    (< (distance p0 p) (distance p1 p))))))))
			 bl))
       ;; find first suitable ray-intersections
       (setq il
	      (mapcar
		(function
		  (lambda (s / s1 s2 p z)
		    (setq s1 (nth (car s) bl) ;_(setq s (list 19 20))
			  s2 (nth (cadr s) bl)
			  p  (ray-inters (nth (car s1) pl)
					 (cdr s1)
					 (nth (car s2) pl)
					 (cdr s2)))
        (if
          (and
            p
            (> (pipl? p pl *gsls_angfuzz*) 0)
            (setq z (suit0 p
                    (list (car s)
                    (format-i (1- (car s)) n)
                    (cadr s))))
          )
		       (list s p z))))
		sl))
       ;; deal neighbor is closed .
       ;; Edited 6.3-2014 , if neighbors number >= 3 , it shoud be Interval returns , until neighbors have same z valve .  
       (setq il (tcgroup il))
       ;; improve determine neighbor more than 2 item .
       ;; for 3 items z valve : {max min max} ->{ min }, {min mid max} -> {min max} , {min max mid}-> {min mid}
       ;;                    {min min max} ->{min min} , {min max1 max2} -> {min max2} , {min min min}-> {min min min}
       (setq il	(mapcar
		  (function
		    (lambda (a / z b c d e ir i) ;_(setq a (nth 1 il) d nil e nil)
		      (setq z
			     (caddar
			       (_vl-sort
				 a
				 (function (lambda (x y) (< (caddr x) (caddr y)))))))
		      (cond
			((not (cadr a)) a)
			((not (caddr a))
			 (vl-remove-if-not
			   (function (lambda (x)
				       (equal z (caddr x) *gsls_disfuzz*)))
			   a))
			(t
			 (setq b (eqgroup a caddr *gsls_disfuzz*))
			 (setq c  (car (vl-remove-if-not
					 (function
					   (lambda (x)
					     (equal z (caddar x) *gsls_disfuzz*)))
					 b))
			       ir (rem (_vl-position c b 1e-6 nil) 2)
			       i  0)
			 (mapcar (function (lambda (x)
					     (if (= (rem i 2) ir)
					       (setq d (cons x d))
					       (setq e (cons x e)))
					     (setq i (1+ i))))
				 b)
			 (mapcar
			   (function car)
			   (append
			     d
			     (vl-remove-if-not
			       (function (lambda (x)
					   (equal z (caddar x) *gsls_disfuzz*)))
			       e)))
			 ))))
		  il)
	     il	(apply (function append) il)
	     il	(_vl-sort il (function (lambda (a b) (< (caddr a) (caddr b))))))
       ;; add first suitable intersections into it's side info , put them closed .
       (setq closed_n 0)
       (foreach	s  il
	 (setq p (cadr s))
	 (setq a (nth (format-i (- (caar s) 2) n) rgl)
	       c (nth (format-i (+ (caar s) 2) n) rgl))
	 ;; add whether the neighbor closed first .
   (cond
     ((eq err 0)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 3) n) (caar s))
                    (= (format-i (- i 3) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 1)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 4) n) (caar s))
                    (= (format-i (- i 4) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 2)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 3)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 4) n) (caar s))
                    (= (format-i (- i 4) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 4)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 5) n) (caar s))
                    (= (format-i (- i 5) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 5)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 6) n) (caar s))
                    (= (format-i (- i 6) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 6)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 7) n) (caar s))
                    (= (format-i (- i 7) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 7)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 8) n) (caar s))
                    (= (format-i (- i 8) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 8)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 9) n) (caar s))
                    (= (format-i (- i 9) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 9)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 10) n) (caar s))
                    (= (format-i (- i 10) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 10)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 11) n) (caar s))
                    (= (format-i (- i 11) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 11)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 12) n) (caar s))
                    (= (format-i (- i 12) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 12)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 13) n) (caar s))
                    (= (format-i (- i 13) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 13)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 14) n) (caar s))
                    (= (format-i (- i 14) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 14)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 15) n) (caar s))
                    (= (format-i (- i 15) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 15)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 16) n) (caar s))
                    (= (format-i (- i 16) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 16)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 17) n) (caar s))
                    (= (format-i (- i 17) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 17)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 18) n) (caar s))
                    (= (format-i (- i 18) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 18)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 19) n) (caar s))
                    (= (format-i (- i 19) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 19)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 20) n) (caar s))
                    (= (format-i (- i 20) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 20)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 21) n) (caar s))
                    (= (format-i (- i 21) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 21)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 22) n) (caar s))
                    (= (format-i (- i 22) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 22)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 23) n) (caar s))
                    (= (format-i (- i 23) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 23)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 24) n) (caar s))
                    (= (format-i (- i 24) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 24)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 25) n) (caar s))
                    (= (format-i (- i 25) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 25)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 26) n) (caar s))
                    (= (format-i (- i 26) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 26)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 27) n) (caar s))
                    (= (format-i (- i 27) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 27)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 28) n) (caar s))
                    (= (format-i (- i 28) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 28)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 29) n) (caar s))
                    (= (format-i (- i 29) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 29)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 30) n) (caar s))
                    (= (format-i (- i 30) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 30)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 31) n) (caar s))
                    (= (format-i (- i 31) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 31)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 32) n) (caar s))
                    (= (format-i (- i 32) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 32)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 33) n) (caar s))
                    (= (format-i (- i 33) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 33)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 34) n) (caar s))
                    (= (format-i (- i 34) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 34)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 35) n) (caar s))
                    (= (format-i (- i 35) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 35)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 36) n) (caar s))
                    (= (format-i (- i 36) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 36)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 37) n) (caar s))
                    (= (format-i (- i 37) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 37)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 38) n) (caar s))
                    (= (format-i (- i 38) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 38)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 39) n) (caar s))
                    (= (format-i (- i 39) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 39)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 40) n) (caar s))
                    (= (format-i (- i 40) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 40)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 41) n) (caar s))
                    (= (format-i (- i 41) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 41)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 42) n) (caar s))
                    (= (format-i (- i 42) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 42)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 43) n) (caar s))
                    (= (format-i (- i 43) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 43)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 44) n) (caar s))
                    (= (format-i (- i 44) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 44)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 45) n) (caar s))
                    (= (format-i (- i 45) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 45)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 46) n) (caar s))
                    (= (format-i (- i 46) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 46)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 47) n) (caar s))
                    (= (format-i (- i 47) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 47)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 48) n) (caar s))
                    (= (format-i (- i 48) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 48)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 49) n) (caar s))
                    (= (format-i (- i 49) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 49)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       ;; according RibarM's catched error :  first vertex error joined , add first determine
       ;; closed line has intersections with closed side's tow ray ,  Edited June 15 , 2014 .
       ((vl-some (function (lambda (i / p0 p1 p2 p3)
                (or (= (format-i (+ i 50) n) (caar s))
                    (= (format-i (- i 50) n) (caar s))
                                        )))
           closed_il))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
     ((eq err 50)
     (gc)
     (cond
       ((and (assoc 70 a)
       (setq a (nth (format-i (1- (caar s)) n) rgl))
       (setq p0 (pnth (cadar a))
             a0 (cdaar a))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (cadr a)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq a (nth (suit-i (format-i (- (caar s) 3) n) 1-) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadar a)) (cdaar a))))
           (< (distance p0 p1) (distance p0 p2)))
       ))
       ((and (assoc 70 c)
       (setq c (nth (format-i (1+ (caar s)) n) rgl))
       (setq p0 (pnth (cadadr c))
             a0 (cdaadr c))
       (setq p1 (ray-int-line	p0
            a0
            (pnth (assoc 10 (car c)))
            p))
       (not (equal p1 p *gsls_disfuzz*))
       ;_after neighbor closed , it's new ray no always must be join determining 
       (setq c (nth (suit-i (format-i (+ (caar s) 3) n) 1+) rgl))
       (or (not (setq p2 (ray-inters p0 a0 (pnth (cadadr c)) (cdaadr c))))		 
            (< (distance p0 p1) (distance p0 p2)))
       ))
       (t
        (if	(not (setq i (_vl-position p tl 1e-6 nil)))
          (setq tl (append tl (list p))
          zl (append zl (list (caddr s)))
          i  (1- (length tl))))
        (setq b	    (nth (caar s) rgl)
        b1	    (list (add-item i nil (car b))
            (add-item i nil (cadr b))
            (cons 70 1))
        rgl	    (subst b1 b rgl)
        closed_n  (1+ closed_n)
        closed_il (cons (caar s) closed_il))
        ;;deal near side info
        (if	(and t
           (setq bi (suit-i (format-i (1- (caar s)) n) 1-))
           (setq fi (suit-i (cadar s) 1+))
           (/= bi fi))
          (setq a	(nth bi rgl)
          c	(nth fi rgl)
          p0	(nth (dxf 10 (car a)) pl)
          p1	(nth (dxf 10 (cadr a)) pl)
          p2	(nth (dxf 10 (car c)) pl)
          p3	(nth (dxf 10 (cadr c)) pl)
          an	(bisector2 p0 p1 p2 p3)
          a1	(list (car a) (add-item i an (cadr a)))
          c1	(list (add-item i an (car c)) (cadr c))
          rgl	(subst a1 a rgl)
          rgl	(subst c1 c rgl))))
     ))
   )
  )
       ;; deal has closed side .
       (_closed)
;;; deal near side of closed-side , until catch another closed side
;;;--------------------------------------------------------------------
      (setq *gsls_disfuzz* (* *gsls_disfuzz* 2)
	     *gsls_angfuzz* (* *gsls_angfuzz* 10))
;;;--------------------------------------------------------------------
       (foo)
;;;--------------------------------------------------------------------
;;; here must reopen error first closed side . and reclosed the first lost closed side .
;;; Edited June 17 2014       
       (_getclosed);_rdl il
       ;; release error closed or crash side 
       (foreach b rdl
	 (setq b (cadr b)
	       i (dxf 10 (car b))
	       bi (format-i (- i 2) n)
	       fi (format-i (+ i 2) n))
	 ;_(if (= i 43) (princ))
	 (setq a (if (member bi closed_il)
		   (assoc2 12 (car (nth (format-i (1- i) n) rgl))))
	       c (if (member fi closed_il)
		   (assoc2 12 (cadr (nth (format-i (1+ i) n) rgl)))))
	 (if (vl-some (function (lambda (a / p0 a1 p1 p2)				
				(and a (cadr a) (caar b) (cadar b) (caadr b) (cadadr b) (setq p0 (pnth (cadr a))
				      a1 (cdar a))
				     (setq p1 (ray-int-line p0 a1 (pnth (caar b)) (pnth (cadar b))))
				     (setq p2 (ray-int-line p0 a1 (pnth (caadr b)) (pnth (cadadr b))))
				      (not (equal p1 p2 *gsls_disfuzz*)))))
		      (list a c))
	   (setq rgl (subst (list (list (cons 12 (dxf (dxf 10 (car b)) bl)) (assoc 10 (car b)))
				  (list (cons 12 (dxf (dxf 10 (cadr b)) bl)) (assoc 10 (cadr b))))
			    b rgl)
		 closed_n (1- closed_n)
		 closed_il (vl-remove i closed_il)
		 ril (cons i ril);_sign just break closed_i , 6.23-2014
		 a (nth (format-i (1- i) n) rgl)
		 c (nth (format-i (1+ i) n) rgl)
		 a1 (list (car a) (cons (cons 12 (if (= (caaddr (cadr a)) 10)
						     (dxf (cdaddr (cadr a)) bl)
                                                   (if (and (caddr (cadr a)) (cadadr a))
						   (angle (pnth (caddr (cadr a)))
							  (pnth (cadadr a))))))
					(cddadr a)))
		 c1 (list (cons (cons 12 (if (= (caaddr (car c)) 10)
						     (dxf (cdaddr (car c)) bl)
                                                   (if (and (caddar c) (cadar c))
						   (angle (pnth (caddar c))
							  (pnth (cadar c))))))
					(cddar c))
			  (cadr c))
		 rgl (subst a1 a rgl)
		 rgl (subst c1 c rgl)
		 )))
       ;; neighbor is closed 
       (setq il
	     (vl-remove nil (mapcar
		(function
		  (lambda (r / s1 s2 p z)
		    (if (and (not (assoc 70 r))
			     (not (member (dxf 10 (car r)) ril));_add  side closed has been break , 6.26-2014
			     (= (length (car r)) (length (cadr r)) 2)
			     (setq s1 (car r) 
			           s2 (cadr r)
			  p  (ray-inters (nth (cdadr s1) pl)
					 (cdar s1)
					 (nth (cdadr s2) pl)
					 (cdar s2)))
			     (> (pipl? p pl *gsls_angfuzz*) 0)
			     (setq z (suit p
				       (list (cdadr s1)
					     (format-i (1- (cdadr s1)) n)
					     (cdadr s2)))))
		      (list (cdadar r) z p r))))
		rgl)))
       (while il
	 (setq a  (car il)
	       b  (cadr il)
	       il (cdr il))
	 (cond ((or (not b) (/= (format-i (1+ (car a)) n) (car b)))
		(setq ill (cons a ill)))
	       ((<= (cadr a) (cadr b))
		(setq ill (cons a ill)
		      il  (cdr il)))))
       (setq il	(_vl-sort (mapcar (function cdr) (reverse ill))
			 (function (lambda (a b) (<= (car a) (car b))))))
       (foreach	ip  il
	 (setq z (car ip)
	       p (cadr ip)
	       b (caddr ip))
	 (if (not (setq i (_vl-position p tl 1e-6 nil)))
	   (setq tl (append tl (list p))
		 zl (append zl (list z))
		 i  (1- (length tl))))
	 (setq b1	 (list (add-item i nil (car b))
			       (add-item i nil (cadr b))
			       (cons 70 1))
	       rgl	 (subst b1 b rgl)
	       closed_n	 (1+ closed_n)
	       closed_il (cons (dxf 10 (car b)) closed_il))
	 (if (and t
		  (setq bi (suit-i (format-i (1- (dxf 10 (car b))) n) 1-))
		  (setq fi (suit-i (dxf 10 (cadr b)) 1+))
		  (/= bi fi))
	   (setq a   (nth bi rgl)
		 c   (nth fi rgl)
		 p0  (nth (dxf 10 (car a)) pl)
		 p1  (nth (dxf 10 (cadr a)) pl)
		 p2  (nth (dxf 10 (car c)) pl)
		 p3  (nth (dxf 10 (cadr c)) pl)
		 an  (bisector2 p0 p1 p2 p3)
		 a1  (list (car a) (add-item i an (cadr a)))
		 c1  (list (add-item i an (car c)) (cadr c))
		 rgl (subst a1 a rgl)
		 rgl (subst c1 c rgl))))      
;;;--------------------------------------------------------------------
       ;; check single no closed side's ray crash closed side
      (setq il (_getsinglenoclosed));_here has a problem , maybe error deal one side ...
      (foreach i il
        (if (and (cadar (nth i rgl)) (cadadr (nth i rgl)))
          (progn
	 (setq a (nth i rgl)
	       p0 (pnth (cadar a))
	       a0 (cdaar a)
	       p1 (pnth (cadadr a))
	       a1 (cdaadr a)
	       i+ (format-i (1+ i) n)
	       i- (format-i (1- i) n)
	       ill nil
	       l (append (cdar a) (cdadr a)))
	;; only check near closed zone.
	 (while (member i+ closed_il) 
	   (setq ill (cons i+ ill)
		 i+ (format-i (1+ i+) n)))
	 (while (member i- closed_il)
	   (setq ill (cons i- ill)
		 i- (format-i (1- i-) n)))
	;; have shared vertices 
	 (setq ill (vl-remove-if-not (function (lambda (i / b)						
						(setq b (nth i rgl)
						      b (list (caar b) (cadar b) (cadadr b)))
						(vl-some (function (lambda (x) (_vl-position x l 1e-6 nil)))
							 b)))
				    ill))
	;; crashed ?
	 (setq crl (vl-remove nil (mapcar
				    (function
				      (lambda (i / b pa pb pc pd pe pf p2)					
					(defun f ()
					  (if (equal pe pa *gsls_disfuzz*)
						 (setq pe nil))
					       (if (equal pf pa *gsls_disfuzz*)
						 (setq pf nil))
					       (cond ((and pe pf)
					      (cond ((< (distance p0 pe) (distance p0 pf))
						     (setq p2 pe))
						    ((setq p2 pf))))
						     (pe (setq p2 pe))
						     (pf (setq p2 pf))))
					(if (= i 1) (princ))
					(setq b (nth i rgl))
					(if (and (assoc 70 b) (caar b) (cadar b) (cadadr b))
					  (progn
					(setq pa (pnth (caar b))
					     pb (pnth (cadar b))
					     pc (pnth (cadadr b)))
					(cond ((equal (caar b) (cadadr a))
					       (setq pe (ray-int-line p0 a0 pa pb)
						     pf (ray-int-line p0 a0 pa pc))
					       (f)
					       (if (and p2 (not (l_int_pl p0 p2 pl))) (list "for" p2 i)))
					      ((setq pe (ray-int-line p1 a1 pa pb)
						     pf (ray-int-line p1 a1 pa pc))
					       (f)					       
					       (if (and p2 (not (l_int_pl p1 p2 pl))) (list "back" p2 i))
					       ))))				       
				       )) ill)))
	 (cond ((and crl (= (caar crl) "back"))
		(setq crl (_vl-sort crl (function (lambda (x y)
						   (< (distance p1 (cadr x)) (distance p1 (cadr y))))))
		      cr (car crl)))
	       ((and crl (= (caar crl) "for"))
		(setq crl (_vl-sort crl (function (lambda (x y)
						   (< (distance p0 (cadr x)) (distance p0 (cadr y))))))
		      cr (car crl))))
	 (if (and cr
		  (setq ty (car cr)
			p2 (cadr cr)
			b (nth (caddr cr) rgl))
		  (assoc 70 b)
                  (cadar b)
                  (caar b)
                  (cadadr b)
                  (caadr b)
             )
	     (progn	   
	   (setq
		 a2 (angle (pnth (cadar b)) (pnth (caar b)))
		 a3 (angle (pnth (cadadr b)) (pnth (caadr b)))
		 rgl (subst (list (cons (cons 12 a2) (cdar b)) (cons (cons 12 a3) (cdadr b)))  b rgl)
		 closed_n (1- closed_n)
		 closed_il (vl-remove (caddr cr) closed_il))
	   (cond ((= ty "for")			  
		  (setq rgl (subst (list (car a) (cons (cons 12 a2) (cddadr a))) a rgl))		  
		  (setq c (nth (suit-i (format-i (1+ (dxf 10 (car b))) n) 1+) rgl))
		  (setq rgl (subst (list (cons (cons 12 a3) (cddar c)) (cadr c)) c rgl)))
		 ((= ty "back")
		  (setq rgl (subst (list (cons (cons 12 a3) (cddar a)) (cadr a)) a rgl))
		  (setq c (nth (suit-i (format-i (1- (dxf 10 (car b))) n) 1-) rgl))
		  (setq rgl (subst (list (car c) (cons (cons 12 a2) (cddadr c)) ) c rgl))))	    
	   ))
       ))
      )
;;;--------------------------------------------------------------------
      (setq *gsls_disfuzz* (* *gsls_disfuzz* 2)
	     *gsls_angfuzz* (* *gsls_angfuzz* 10))
;;;--------------------------------------------------------------------
       (foo1)       
;;;--------------------------------------------------------------------
       (setq *gsls_angfuzz* (* *gsls_angfuzz* 5)
	     *gsls_disfuzz* (* *gsls_disfuzz* 2.5)
	     i%%	    0)
;;;--------------------------------------------------------------------
       (_closed2)
;;;--------------------------------------------------------------------
    (setq rgl11 (vl-remove nil (mapcar (function (lambda (x) (if (eq (car x) 11) x))) (apply (function append) (vl-remove '(70 . 1) (apply (function append) rgl))))))
    (foreach p11 (unique rgl11)
      (if (not (member p11 (cdr (member p11 rgl11)))) (setq tst11 (cons t tst11)) (setq tst11 (cons nil tst11)))
    )
    (if
      (or
        (not
          (vl-every (function (lambda (x) (assoc 70 x)))
                    rgl
          )
        )
        (eval (cons 'or tst11))
      )
      (progn
        (setq err (1+ err))
        (if (<= err 50)
          (progn
            (setq     a     nil   a1    nil   ab    nil   an    nil   b     nil   bi    nil   bii   nil
                bl    nil   c     nil   c1    nil   cf    nil   closed_il   nil   closed_n    nil   d     nil
                e     nil   fi    nil   fii   nil   i     nil   i%    nil   il    nil   ip0   nil   ip1   nil   li    nil
                ll    nil   n     nil   p     nil   p0    nil   p1    nil   p2    nil   p3    nil   rdl   nil   rgl   nil
                i%%   nil   rml   nil   rnl   nil   sil   nil   sl    nil   ti    nil   tl    nil   z     nil   zl    nil
                rel   nil   pl1   nil   b1    nil   i+    nil   i-    nil   crl   nil   cr    nil   a0    nil   a2    nil
                a3    nil   ill   nil   rgl11 nil   tst11 nil
            )
            (start pl)
          )
        )
      )
    )
    ;; test result
    (foreach r rgl
      (if (assoc 70 r)
        (mapcar
          (function
            (lambda (a)
              (setq b (mapcar (function (lambda (a) (pnth a))) a))
              (mapcar (function (lambda (c d)
                                  (setq li (cons (list c d) li))
                                )
                      )
                      b
                      (cdr b)
              )
            )
          )
          (list (car r) (cadr r))
        )
      )
    )
    (while li
      (if
        (not
          (vl-some (function (lambda (x)
                               (or (and (equal (car x) (caar li) 1e-8)
                                        (equal (cadr x) (cadar li) 1e-8)
                                   )
                                   (and (equal (cadr x) (caar li) 1e-8)
                                        (equal (car x) (cadar li) 1e-8)
                                   )
                               )
                             )
                   )
                   (cdr li)
          )
        )
         (setq ll (cons (car li) ll))
      )
      (setq li (cdr li))
    )
    (foreach l ll
      (entmake (list
                 '(0 . "LINE")
                 (cons 10 (car l))
                 (cons 11 (cadr l))
               )
      )
    )
  )


  ;;------------------------------------main routine ------------------------------;;

  (setq e (car (entsel "\nSelect a closed polygon :")))
                                        ;  (setq adoc (vla-get-activedocument (vlax-get-acad-object)))
                                        ;  (vla-startundomark adoc)
  (setq #gsls_systemvar# (list "CMDECHO" "CLAYER"))
  (_svos) ;_undo begin , system variables store .
  ;|
  (setq area (vlax-curve-getarea e))
  (if (< area 1000000000000.0)
    (progn
      (setq scf (fix (1+ (sqrt (/ 1000000000000.1 area)))))
      (setq scf
             (if (equal
                   (rem (/ scf (expt 10.0 (strlen (rtos scf 2 0)))) 0.5)
                   0.0
                   1e-8
                 )
               scf
               (* (+ (/ scf (expt 10.0 (strlen (rtos scf 2 0))))
                     (- 0.5
                        (rem (/ scf (expt 10.0 (strlen (rtos scf 2 0))))
                             0.5
                        )
                     )
                  )
                  (expt 10.0 (strlen (rtos scf 2 0)))
               )
             )
      )
      (alert "You must scale polyline - quitting")
      (prompt
        (strcat
          "\nYou must scale polyline with this factor to make routine compute ridges correctly : "
          (rtos scf 2 15)
        )
      )
      (prompt
        (strcat
          "\nInverse scale factor to return scaled solution back is : "
          (rtos (/ 1.0 scf) 2 15)
        )
      )
      (textscr)
      (exit)
    )
  )
|;
  (setq pl (lm:entity->pointlist e) ;_for pl with arc 
        pl (remove-same-pts pl *gsls_disfuzz*)
  ) ;_has doubles points in pl with arc
  (setq err 0)
  (start pl)
  (_clos) ;_undo end , system variables reset .  
)
